/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.nether_portal;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2802;
import net.minecraft.class_2812;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_4076;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FastBlockAccess(class_2826[] sections, int lowerCX, int lowerCY, int lowerCZ, int lX, int lY, int lZ, class_1937 world) {
    public static FastBlockAccess from(class_1937 world, class_1923 centerChunkPos, int radiusChunks) {
        int lowerCX = centerChunkPos.field_9181 - radiusChunks;
        int lowerCY = world.method_32891();
        int lowerCZ = centerChunkPos.field_9180 - radiusChunks;
        int upperCX = centerChunkPos.field_9181 + radiusChunks;
        int upperCY = world.method_31597();
        int upperCZ = centerChunkPos.field_9180 + radiusChunks;
        return FastBlockAccess.from(world, lowerCX, upperCX, lowerCY, upperCY, lowerCZ, upperCZ);
    }

    @NotNull
    public static FastBlockAccess from(class_1937 world, int lowerCX, int upperCXExclusive, int lowerCY, int upperCYExclusive, int lowerCZ, int upperCZExclusive) {
        int lX = upperCXExclusive - lowerCX;
        int lY = upperCYExclusive - lowerCY;
        int lZ = upperCZExclusive - lowerCZ;
        int minSectionY = world.method_32891();
        int maxSectionYExclusive = world.method_31597();
        Validate.isTrue((lowerCY >= minSectionY ? 1 : 0) != 0, (String)"Min section Y out of range", (Object[])new Object[0]);
        Validate.isTrue((upperCYExclusive <= maxSectionYExclusive ? 1 : 0) != 0, (String)"Max section Y out of range", (Object[])new Object[0]);
        class_2802 chunkSource = world.method_8398();
        class_2826[] sections = new class_2826[lX * lY * lZ];
        for (int cx = lowerCX; cx < upperCXExclusive; ++cx) {
            for (int cz = lowerCZ; cz < upperCZExclusive; ++cz) {
                class_2818 chunk = chunkSource.method_12126(cx, cz, false);
                if (chunk == null || chunk instanceof class_2812) continue;
                class_2826[] column = chunk.method_12006();
                for (int cy = lowerCY; cy < upperCYExclusive; ++cy) {
                    class_2826 section = column[cy - minSectionY];
                    if (section == null || section.method_38292()) continue;
                    int index = cx - lowerCX + (cy - lowerCY) * lX + (cz - lowerCZ) * lX * lY;
                    sections[index] = section;
                }
            }
        }
        return new FastBlockAccess(sections, lowerCX, lowerCY, lowerCZ, lX, lY, lZ, world);
    }

    @NotNull
    public class_2680 getBlockState(int x, int y, int z) {
        int cx = x >> 4;
        int cy = y >> 4;
        int cz = z >> 4;
        class_2826 section = this.getSection(cx, cy, cz);
        if (section == null) {
            return class_2246.field_10124.method_9564();
        }
        return section.method_12254(x & 0xF, y & 0xF, z & 0xF);
    }

    @Nullable
    public class_2826 getSection(int cx, int cy, int cz) {
        if (cx < this.lowerCX || cx >= this.lowerCX + this.lX || cy < this.lowerCY || cy >= this.lowerCY + this.lY || cz < this.lowerCZ || cz >= this.lowerCZ + this.lZ) {
            return null;
        }
        int index = cx - this.lowerCX + (cy - this.lowerCY) * this.lX + (cz - this.lowerCZ) * this.lX * this.lY;
        return this.sections[index];
    }

    public Stream<class_4076> sectionPoses() {
        return IntStream.range(0, this.lY).boxed().flatMap(y -> IntStream.range(0, this.lZ).boxed().flatMap(z -> IntStream.range(0, this.lX).mapToObj(x -> class_4076.method_18676((int)(x + this.lowerCX), (int)(y + this.lowerCY), (int)(z + this.lowerCZ)))));
    }

    public Stream<class_1923> chunkPoses() {
        return IntStream.range(0, this.lZ).boxed().flatMap(z -> IntStream.range(0, this.lX).mapToObj(x -> new class_1923(x + this.lowerCX, z + this.lowerCZ)));
    }

    public int minSectionX() {
        return this.lowerCX;
    }

    public int minSectionY() {
        return this.lowerCY;
    }

    public int minSectionZ() {
        return this.lowerCZ;
    }

    public int maxSectionXInclusive() {
        return this.lowerCX + this.lX - 1;
    }

    public int maxSectionYInclusive() {
        return this.lowerCY + this.lY - 1;
    }

    public int maxSectionZInclusive() {
        return this.lowerCZ + this.lZ - 1;
    }

    public int maxSectionXExclusive() {
        return this.lowerCX + this.lX;
    }

    public int maxSectionYExclusive() {
        return this.lowerCY + this.lY;
    }

    public int maxSectionZExclusive() {
        return this.lowerCZ + this.lZ;
    }
}

